import asyncio
from py_pli.pylib import VUnits
import config_enum.scan_table_enum as scan_table_enum
import time as t
from datetime import datetime as DT

# 2020-09-16/Kay Struebing
# Klimakammer-Tests
    
# Init Hardware

async def init():
    await VUnits.instance.hal.StartupHardware()
    print("Hardware started,\n")
    await VUnits.instance.hal.InitializeDevice()
    print("Device initialized.\n")


# Init OneMoverDevices

async def as_init():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.InitializeDevice()
    stepErrors = await as1.Home()    
    print("Aperture Slider homed, Step-Error: " + str(stepErrors))

async def els_init():
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.InitializeDevice()
    stepErrors = await els.Home()    
    print("ELS homed, Step-Error: " + str(stepErrors))

async def bld_init():
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.InitializeDevice()
    stepErrors = await bld.Home()    
    print("BottomLightDirector homed, Step-Error: " + str(stepErrors))
    
async def all_home():
    step_error = await VUnits.instance.hal.oneMoverDevices["ApertureSlider1"].Home()    
    print(f"ApertureSlider1 homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.focusMover.Home()
    print(f"FocusMover homed, Error = {step_error}\n")
    step_error = await VUnits.instance.hal.filterModuleSlider.Home()
    print(f"FilterModuleSlider homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.scan_table.Home()
    print(f"ScanTable homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.plateDoor.Home()
    print(f"PlateDoor homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"].Home()        
    print(f"ExcitationLightSelector homed,Error = {step_error}\n")
    step_error = await VUnits.instance.hal.oneMoverDevices["BottomLightDirector"].Home()
    print(f"BottomLightDirector homed,Error = {step_error}\n")
    print('All Mover at home.')

# Test Functions

# Temp-Cycle
async def temp_cycle(duty, idle, loops, cycles):
    print("Movertest Temperature cycle:\n")
    print(f"Duty: {duty} Minutes\n")
    print(f"Idle: {idle} Minutes\n")
    print("Start: " + DT.now().strftime('%Y-%m-%d_%H-%M'))
    for i in range (loops):
        start = (t.time() - start)/60.0
        print(f"Mover duty, Loop # {i}\n")
        await move_time(duty, cycles)
        print(f"Mover idle, {idle} minutes\n")
        t.sleep(idle * 60)
    duration = (t.time()/60) - start
    print("Stop: + DT.now().strftime('%Y-%m-%d_%H-%M')\n")
    print(f"Duration: {duration}")
    
# Mover Functions

# Mover moves for n loops
async def move_loop(loops, cycles):
    log_filename = "move_loop_" + DT.now().strftime('%Y-%m-%d_%H-%M') + ".log"
    header = f"Movertest Loops: {loops} Loops, {cycles} Cycles per Loop:"
    log_header(log_filename, header)
    print(f"===Movertest Loops, see {log_filename} for results.")
    entry = "FilterModuleSlider, FocusMover, PlateDoor, ScanTableX, ScanTableY, ApertureSlider1, ExcitLightSel"
    log_entry(log_filename, entry)    
    start = t.time()
    for i in range(loops):
        print(f"Mover Loop {i}")
        await all_mover(log_filename, cycles)
    duration = (t.time() - start) /60.0
    entry = f"===Terminated {loops} Loops, {duration:.0f} Minutes"
    log_entry(log_filename, entry)   
    print(f"===Movertest Loops terminated: Logfile: {log_filename}, Loops: {loops}, Cycles per Loop: {cycles}, Runtime: {duration:.0f}min")


# Moves for specific time in minutes
async def move_time(minutes, cycles):
    log_filename = "move_time_" + DT.now().strftime('%Y-%m-%d_%H-%M') + ".log"
    header = f"Movertest Time: Duration: {minutes}min, {cycles} Cycles per Loop:"
    log_header(log_filename, header)
    print(f"===Movertest Time, see {log_filename} for results.")
    entry = "FilterModuleSlider, FocusMover, PlateDoor, ScanTableX, ScanTableY, ApertureSlider1, ExcitLightSel"
    log_entry(log_filename, entry)    
    start = t.time()
    loops = 1
    while ((t.time() - start)/60.0 < minutes):
        print(f"Mover Loop {loops}")
        await all_mover(log_filename, cycles)
        loops += 1
    duration = (t.time() - start)/60.0
    entry = f"===Terminated {loops} Loops, {duration:.0f} Minutes"
    log_entry(log_filename, entry)
    print(f"===Movertest Time terminated: Logfile: {log_filename}, Runtime: {duration:.0f}min, {loops} Loops")
    
#Moves all movers simultaniously for x cycles and writes step-errors in Logfile
async def all_mover(log, cycles):
    start = t.time()
    await asyncio.gather(fms_move(cycles),
                         fm_move(cycles),
                         door_move(cycles),
                         st_move(cycles),
                         as_move(cycles),
                         els_move(cycles))                        
    duration = t.time() - start
    time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M-%S')
    fms_err = VUnits.instance.hal.filterModuleSlider.Mover.LastHomeStepErrors
    fm_err = VUnits.instance.hal.focusMover.Mover.LastHomeStepErrors
    door_err = VUnits.instance.hal.plateDoor.Mover.LastHomeStepErrors
    st_err = VUnits.instance.hal.scan_table.CoreXY.LastHomeStepErrors
    as1_err = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"].Mover.LastHomeStepErrors
    els_err = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"].Mover.LastHomeStepErrors    
    entry = f"{time_stamp}, {fms_err}, {fm_err}, {door_err}, {st_err[0]}, {st_err[1]}, {as1_err}, {els_err}"
    log_entry(log, entry)
    print(entry + "\n")    
   


async def fms_move(cycles):
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.Home()    
    await filter_slider.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")        
        await filter_slider.Move(22)
        await asyncio.sleep(0.5)
        await filter_slider.Move(55.2)
        #t.sleep(0.5)
        await filter_slider.Move(79.2)
        #t.sleep(0.5)
        await filter_slider.Move(103.2)
        #t.sleep(0.5)
        await filter_slider.Move(127.2)
        #t.sleep(0.5)
        await filter_slider.Move(151.2)
        #t.sleep(0.5)
        await filter_slider.Move(175.2)
        #t.sleep(0.5)
        await filter_slider.Move(0)
        #t.sleep(0.5)        
    await filter_slider.Home()
    print(f"Filter Module Slider Step Errors: {filter_slider.Mover.LastHomeStepErrors}")

async def fms(filter_nr):
    filter_slider = VUnits.instance.hal.filterModuleSlider
    await filter_slider.UseProfile(1)
    position = 55.2 + (filter_nr - 1) * 24.0
    await filter_slider.Move(position)
    print(f"Filter Module {filter_nr}")


async def fm_move(cycles):
    focus_mover = VUnits.instance.hal.focusMover
    await focus_mover.Home()    
    await focus_mover.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")        
        await focus_mover.Move(3.95)
        await focus_mover.Move(12.5)
        await focus_mover.Move(0)
    await focus_mover.Home()
    print(f"Focus Mover Step Errors: {focus_mover.Mover.LastHomeStepErrors}")


async def door_move(cycles):
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.Home()    
    await plate_door.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")        
        await plate_door.Open()
        await plate_door.Close()
    await plate_door.Home()
    print(f"Plate Door Step Errors: {plate_door.Mover.LastHomeStepErrors}")

async def pd_open():
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.UseProfile(1)    
    await plate_door.Open()    
    print("Plate Door open.")

async def pd_close():
    plate_door = VUnits.instance.hal.plateDoor
    await plate_door.UseProfile(1)    
    await plate_door.Close()    
    print("Plate Door closed.")


async def st_move(cycles):
    scan_table = VUnits.instance.hal.scan_table
    await scan_table.Home()
    await scan_table.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")
        await scan_table.Move(0, 170)
        t.sleep(0.5)
        await scan_table.Move(170, 170)
        t.sleep(0.5)
        await scan_table.Move(170, 0)
        t.sleep(0.5)
        await scan_table.Move(0, 0)
        t.sleep(0.5)        
    await scan_table.Home()
    print(f"Scan Table X Step Errors: {scan_table.CoreXY.LastHomeStepErrors[0]}")
    print(f"Scan Table Y Step Errors: {scan_table.CoreXY.LastHomeStepErrors[1]}")   

async def as_move(cycles):
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.Home()  
    await as1.UseProfile(1)
    for i in range(cycles):
        print(f"Cycle {i}")
        await as1.Move(4.4)
        await as1.Move(-4.2)
        await as1.Move(0.2)
    await as1.Home()
    step_error = as1.Mover.LastHomeStepErrors
    print(f"Aperture Slider Step Errors: {step_error}")
    

async def ap(pos):
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(pos)
    print(f"Aperture Position: {pos}")
    
async def as_small():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(4.4)
    print("Small Aperture.")

async def as_close():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)    
    await as1.Move(0.5)
    print("Aperture 1 closed.")

async def as_home():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.Home()
    print("Aperture 1 home.")

async def as_big():
    as1 = VUnits.instance.hal.oneMoverDevices["ApertureSlider1"]
    await as1.UseProfile(1)
    await as1.Move(-4.2)
    print("Big Aperture.")

async def els_f1():
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.UseProfile(1)
    await els.Move(23.8)
    print("Exc.LightSel Flash 1.")

async def els_f2():
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.UseProfile(1)
    await els.Move(203.8)
    print("Exc.LightSel Flash 1.")


async def els_move(cycles):
    els = VUnits.instance.hal.oneMoverDevices["ExcitationLightSelector"]
    await els.Home()  
    await els.UseProfile(1)
    for i in range(cycles):
        await els.Move(115)
        t.sleep(0.5)
        await els.Move(205)
        t.sleep(0.5)
        await els.Move(207)
        t.sleep(0.5)
        await els.Move(247)
        t.sleep(0.5)
        await els.Move(250)
    await els.Home()
    els_err = els.Mover.LastHomeStepErrors
    print(f"Excitation Light Selector Step Errors: {els_err}")

async def bld_move(cycles):
    bld = VUnits.instance.hal.oneMoverDevices["BottomLightDirector"]
    await bld.Home()  
    await bld.UseProfile(1)
    for i in range(cycles):
        await bld.GotoPosition(["Positions", "ABS_Photo Diode_1_Position", None])
        t.sleep(0.5)
        await bld.GotoPosition(["Positions", "PMT_Bottom_Reading_Position", None])
        t.sleep(0.5)
        await bld.GotoPosition(["Positions", "PMT_Top_Reading_Position", None])
        t.sleep(1)
        await bld.Move(0)
    await bld.Home()
    bld_err = bld.Mover.LastHomeStepErrors
    print(f"Bottom Light Director Step Errors: {bld_err}")


# Logging functions

def log_entry(fname, entry):
    file = open(fname, 'a')
    file.write(entry + "\n")
    file.close()
    print(f"Log-Entry written in {fname}")

def log_header(fname, header):
    file = open(fname, 'w')
    file.write(header + "\n")
    file.close()
    print(f"Log-file write to {fname}")

def log_footer(fname, footer):
    time_stamp = DT.now().strftime('%Y-%m-%d_%H-%M-%S')    
    file = open(fname, 'a')
    file.write(time_stamp + footer + "\n")
    file.close()
    print(f"Log-file written in {fname}")

